/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.Validator;
import com.ibm.hwmca.fw.servlet.pmod.util.TimeFormatter;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class TimeValidator
extends Validator {
    private static final String TRACE_MASKT = "XPMNVTVT";
    private static final String TRACE_MASKF = "XPMNVTVF";
    protected Calendar earliest = null;
    protected Calendar latest = null;

    public void setEarliest(Calendar earliest) {
        Trace.trace(TRACE_MASKF, "TimeValidator.setEarliest(" + earliest + ")");
        this.earliest = earliest;
    }

    public void setLatest(Calendar latest) {
        Trace.trace(TRACE_MASKF, "TimeValidator.setLatest(" + latest + ")");
        this.latest = latest;
    }

    private Calendar formCalendar(String rawString) throws ParseException {
        try {
            Date time = TimeFormatter.convertStringToDate(rawString);
            return this.formCalendar(time);
        }
        catch (Exception e) {
            throw new ParseException("Unable to parse: " + rawString, 0);
        }
    }

    private Calendar formCalendar(Date raw) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(raw);
        return calendar;
    }

    public void validate(Object value) throws ValidationException {
        Trace.trace(TRACE_MASKF, "TimeValidator.validate(" + value + ")");
        if (value != null) {
            Calendar candidate;
            block9: {
                candidate = null;
                try {
                    if (value instanceof Calendar) {
                        candidate = (Calendar)value;
                        break block9;
                    }
                    if (value instanceof String) {
                        candidate = this.formCalendar((String)value);
                        break block9;
                    }
                    if (value instanceof Date) {
                        candidate = this.formCalendar((Date)value);
                        break block9;
                    }
                    Trace.trace(TRACE_MASKF, "TimeValidator.validate(" + value + ") rejected (unhandleable)");
                    throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "TimeUnableToHandle", new Object[]{value.getClass().toString()}));
                }
                catch (ParseException e) {
                    Trace.trace(TRACE_MASKF, "TimeValidator.validate(" + value + ") rejected (parse)");
                    throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "TimeFailedToParse"));
                }
            }
            if (this.latest != null && candidate.after(this.latest)) {
                Trace.trace(TRACE_MASKF, "TimeValidator.validate(" + value + ") rejected (beyond)");
                throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "TimeAfter"));
            }
            if (this.earliest != null && candidate.before(this.earliest)) {
                Trace.trace(TRACE_MASKF, "TimeValidator.validate(" + value + ") rejected (before)");
                throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "TimeBefore"));
            }
        } else {
            Trace.trace(TRACE_MASKF, "TimeValidator.validate(" + value + ") accepted (null)");
            return;
        }
        Trace.trace(TRACE_MASKF, "TimeValidator.validate(" + value + ") accepted");
    }
}

